#include <struct.h>
#include "change.h"
#include "resource.h"

/////////////////////////////////////////////////////////////////////
//		Class for "Change Object to" dialog
/////////////////////////////////////////////////////////////////////
long		  numnames;
CString		KnownObjects[60];
CString		DummyNames[24];
CString		Flashings[6];
CString		Colors[8];
CString		Blinks[20];
CString		Delays[20];
CString		Intencities[20];



BEGIN_MESSAGE_MAP(CChangeDialog, CDialog)
	ON_COMMAND(IDOK, OnOK)
	ON_CBN_SELCHANGE(IDC_NAMECOMBO, OnNamesChange)
END_MESSAGE_MAP()



BOOL CChangeDialog::OnInitDialog()
{
  CDialog::OnInitDialog();

	pDamagesCheck	= (CButton*)GetDlgItem(IDC_DAMAGES);
	pNameCombo		= (CComboBox*)GetDlgItem(IDC_NAMECOMBO);
	pColorCombo		= (CComboBox*)GetDlgItem(IDC_COLOR);
	pIntencityCombo	= (CComboBox*)GetDlgItem(IDC_INTENCITY);
	pDelayCombo		= (CComboBox*)GetDlgItem(IDC_DELAY);
	pBlinkCombo		= (CComboBox*)GetDlgItem(IDC_BLINK);
	pFlashingCombo	= (CComboBox*)GetDlgItem(IDC_FLASHING);
	pDummyList		= (CListBox*)GetDlgItem(IDC_LIST);

	DummyNames[0]	= "Headlight";			DummyNames[1]	= "H";
	DummyNames[2]	= "Taillight";			DummyNames[3]	= "T";
	DummyNames[4]	= "Breaklight";			DummyNames[5]	= "B";
	DummyNames[6]	= "Reverselight";		DummyNames[7]	= "R";
	DummyNames[8]	= "Direction Indicator";DummyNames[9]= "P";
	DummyNames[10]	= "Siren";				DummyNames[11]= "S";
	DummyNames[12]	= "License Plate (Europe)";DummyNames[13]= ":LICENSE_EURO";
	DummyNames[14]	= "License Plate (high)";DummyNames[15]= ":LICENSE";
	DummyNames[16]	= "License Plate (medium)";DummyNames[17]= ":LICMED";
	DummyNames[18]	= "License Plate (low)";DummyNames[19]= ":LICLOW";
	DummyNames[20]	= "Smoke generator";	DummyNames[21]= ":SMOKE";
	DummyNames[22]	= "Water generator";	DummyNames[23]= ":WATER";

	Colors[0]		= "White";				Colors[1] = "W";
	Colors[2]		= "Red";				Colors[3] = "R";
	Colors[4]		= "Blue";				Colors[5] = "B";
	Colors[6]		= "Orange";				Colors[7] = "O";

	Flashings[0]	= "No flashing";		Flashings[1]="YN";
	Flashings[2]	= "Flashing 1";			Flashings[3]="YO";
	Flashings[4]	= "Flashing 2";			Flashings[5]="YE";

	Delays[0]		= "No Delay";			Delays[1]	= "0";
	Delays[2]		= "1";					Delays[3]	= "1";
	Delays[4]		= "2";					Delays[5]	= "2";
	Delays[6]		= "3";					Delays[7]	= "3";
	Delays[8]		= "4";					Delays[9]	= "4";
	Delays[10]		= "5";					Delays[11]	= "5";
	Delays[12]		= "6";					Delays[13]	= "6";
	Delays[14]		= "7";					Delays[15]	= "7";
	Delays[16]		= "8";					Delays[17]	= "8";
	Delays[18]		= "9";					Delays[19]	= "9";

	Blinks[0]		= "Constant";			Blinks[1]	= "0";
	Blinks[2]		= "Moment #1";			Blinks[3]	= "1";
	Blinks[4]		= "Moment #2";			Blinks[5]	= "2";
	Blinks[6]		= "Moment #3";			Blinks[7]	= "3";
	Blinks[8]		= "Moment #4";			Blinks[9]	= "4";
	Blinks[10]		= "Moment #5";			Blinks[11]	= "5";
	Blinks[12]		= "Moment #6";			Blinks[13]	= "6";
	Blinks[14]		= "Moment #7";			Blinks[15]	= "7";
	Blinks[16]		= "Moment #8";			Blinks[17]	= "8";
	Blinks[18]		= "Moment #9";			Blinks[19]	= "9";

	Intencities[0]	= "Broken (0)";			Intencities[1]= "0";
	Intencities[2]	= "1";					Intencities[3]= "1";
	Intencities[4]	= "2";					Intencities[5]= "2";
	Intencities[6]	= "3";					Intencities[7]= "3";
	Intencities[8]	= "4";					Intencities[9]= "4";
	Intencities[10]	= "5";					Intencities[11]= "5";
	Intencities[12]	= "6";					Intencities[13]= "6";
	Intencities[14]	= "7";					Intencities[15]= "7";
	Intencities[16]	= "8";					Intencities[17]= "8";
	Intencities[18]	= "9";					Intencities[19]= "9";

	if (!pDamagesCheck	||
		!pNameCombo		||
		!pColorCombo	||
		!pIntencityCombo||
		!pDelayCombo	||
		!pBlinkCombo	||
		!pFlashingCombo	||
		!pDummyList)
		return FALSE;
	int i;

	for (i = 0; i < numnames; i++)
		pNameCombo->AddString(KnownObjects[i*2+1]);
	for (i = 0; i < 4; i++)
		pColorCombo->AddString(Colors[i*2]);
	for (i = 0; i < 3; i++)
		pFlashingCombo->AddString(Flashings[i*2]);
	for (i = 0; i < 10; i++)
		pIntencityCombo->AddString(Intencities[i*2]);
	for (i = 0; i < 10; i++)
		pBlinkCombo->AddString(Blinks[i*2]);
	for (i = 0; i < 10; i++)
		pDelayCombo->AddString(Delays[i*2]);
	for (i = 0; i < 12; i++)
		pDummyList->AddString(DummyNames[i*2]);
	
	DummyMode	= FALSE;
	DummyLight	= FALSE;
	BOOL	found = FALSE;
	CString str = pName;
	for (i = 0; (!found && (i < numnames)); i++)
	{
		if (str.Find(KnownObjects[i*2]) >= 0)
		{//found match;
			DummyMode = (i == numnames-1);
			if (DummyMode)
			{
				str = str.Right(str.GetLength()-str.Find(KnownObjects[i*2+1]) - KnownObjects[i*2+1].GetLength()-1);
				DummyLight = (str.GetAt(0) != ':');
			}
			else
			{
				if (str.Find("[D]") >= 0)
					pDamagesCheck->SetCheck(1);
			}
			found = TRUE;
			pNameCombo->SetCurSel(i);
		}//found match;
	}

	if (found)
	{//
		if (DummyMode)
		{//dummy
			if (!DummyLight)
			{//check names;
				for (i = 6; i < 12; i++)
					if ( str.Find(DummyNames[i*2+1]) >=0)
					{//found dummy
						pDummyList->SetCurSel(i);
					}
			}//check names;
			else
			{//translate light
				for (i = 0; i < 6; i++)
					if ( str.GetAt(0) == DummyNames[i*2+1])
					{//found name
						pDummyList->SetCurSel(i);
					}
				for (i = 0; i < 4; i++)
					if ( str.GetAt(1) == Colors[i*2+1])
					{//this color
						pColorCombo->SetCurSel(i);
					}
				for (i = 0; i < 3; i++)
					if ((str.GetAt(2) == Flashings[i*2+1].GetAt(0)) && (str.GetAt(3) == Flashings[i*2+1].GetAt(1)))
					{//this flash
						pFlashingCombo->SetCurSel(i);
					}
				for (i = 0; i < 10; i++)
					if ( str.GetAt(4) == Intencities[i*2+1])
					{//this intensity
						pIntencityCombo->SetCurSel(i);
					}
				for (i = 0; i < 10; i++)
					if ( str.GetAt(5) == Blinks[i*2+1])
					{//this Blick
						pBlinkCombo->SetCurSel(i);
					}
				for (i = 0; i < 10; i++)
					if ( str.GetAt(5) == Delays[i*2+1])
					{//this Delay
						pDelayCombo->SetCurSel(i);
					}
			}//translate light
		}//dummy
	}//
	OnNamesChange();

	return TRUE;
}



afx_msg	void CChangeDialog::OnOK()
{
	DummyMode	= (pNameCombo->GetCurSel() == numnames-1);
	DummyLight	= (pDummyList->GetCurSel() < 6);
	BOOL	found = FALSE;
	CString str = "";

	if (DummyMode)
	{//dummy
		str = "Dummy:";
		if (!DummyLight)
		{//check names;
			if (pDummyList->GetCurSel() >=0)
				str = DummyNames[pDummyList->GetCurSel()*2+1];
		}//check names;
		else
		{//translate light
			if (pDummyList->GetCurSel()>=0)
				str+=DummyNames[pDummyList->GetCurSel()*2+1];
			if (pColorCombo->GetCurSel()>=0)
				str+=Colors[pColorCombo->GetCurSel()*2+1];
			if (pFlashingCombo->GetCurSel()>=0)
				str+=Flashings[pFlashingCombo->GetCurSel()*2+1];
			if (pIntencityCombo->GetCurSel()>=0)
				str+=Intencities[pIntencityCombo->GetCurSel()*2+1];
			if (pBlinkCombo->GetCurSel()>=0)
				str+=Blinks[pBlinkCombo->GetCurSel()*2+1];
			if (pDelayCombo->GetCurSel()>=0)
				str+=Delays[pDelayCombo->GetCurSel()*2+1];
		}//light
	}//dummy
	else
	{
		if (pNameCombo->GetCurSel() >= 0)
			str = KnownObjects[pNameCombo->GetCurSel()*2];
		if (pDamagesCheck->GetCheck() == 1)
			str+="[D]";
	}
	strcpy(pName, "-FCE temp object-");
	strcpy(pName, CurrentState.CurrentParams.Objects->GetSequentalName(str.GetBuffer(str.GetLength())));

	EndDialog(IDOK);
}


afx_msg	void CChangeDialog::OnNamesChange()
{
	DummyMode	= (pNameCombo->GetCurSel() == numnames-1);
	if (DummyMode)
	{
		pDamagesCheck->EnableWindow(FALSE);
		pColorCombo->EnableWindow(TRUE);
		pIntencityCombo->EnableWindow(TRUE);
		pDelayCombo->EnableWindow(TRUE);
		pBlinkCombo->EnableWindow(TRUE);
		pFlashingCombo->EnableWindow(TRUE);
		pDummyList->EnableWindow(TRUE);
	}
	else
	{
		pDamagesCheck->EnableWindow(TRUE);
		pColorCombo->EnableWindow(FALSE);
		pIntencityCombo->EnableWindow(FALSE);
		pDelayCombo->EnableWindow(FALSE);
		pBlinkCombo->EnableWindow(FALSE);
		pFlashingCombo->EnableWindow(FALSE);
		pDummyList->EnableWindow(FALSE);
	}
}